/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.block.ThermolithBlock;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermolithBlockEntity
extends BlockEntity {
    private int signal = 0;

    public ThermolithBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.THERMOLITH_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof ThermolithBlockEntity) {
            ThermolithBlockEntity thermoTE = (ThermolithBlockEntity)te;
            thermoTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level.m_46467_() % 20L == 0L && !level.f_46443_) {
            double temperature = Temperature.getTemperatureAt(pos, level);
            int newSignal = (int)CSMath.blend(0.0, 15.0, temperature, ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)ThermolithBlock.FACING);
            if (newSignal != this.signal) {
                this.signal = newSignal;
                level.m_46672_(pos, state.m_60734_());
                level.m_46672_(pos.m_121945_(facing), this.f_58857_.m_8055_(pos.m_121945_(facing)).m_60734_());
            }
            if (this.signal == 0) {
                if (((Boolean)state.m_61143_((Property)ThermolithBlock.POWERED)).booleanValue()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ThermolithBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                }
            } else if (!((Boolean)state.m_61143_((Property)ThermolithBlock.POWERED)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ThermolithBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public int getSignal() {
        return this.signal;
    }
}

